/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity;

import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.ModEntities;
import dev.toma.gunsrpg.common.init.Skills;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class GrenadeEntity
extends ProjectileEntity
implements IEntityAdditionalSpawnData {
    public static final Vector3d AIR_DRAG_MULTIPLIER = new Vector3d(0.98, 0.98, 0.98);
    public static final Vector3d GROUND_DRAG_MULTIPLIER = new Vector3d(0.7, 0.7, 0.7);
    public static final float BOUNCE_MODIFIER = 0.25f;
    public int fuse;
    public float rotation;
    public float lastRotation;
    public int timesBounced = 0;
    public Item item;
    public LazyOptional<ItemStack> renderStack = LazyOptional.of(() -> new ItemStack((IItemProvider)this.item));
    private int blastRadius;
    private boolean explodesOnImpact;

    public GrenadeEntity(EntityType<? extends GrenadeEntity> type, World world) {
        this(type, world, null, 100, 3, false, Items.field_190931_a);
    }

    public GrenadeEntity(World world) {
        this(world, null);
    }

    public GrenadeEntity(World world, LivingEntity thrower) {
        this((EntityType<? extends GrenadeEntity>)((EntityType)ModEntities.GRENADE.get()), world, thrower, 100, 3, false, Items.field_190931_a);
    }

    public GrenadeEntity(EntityType<? extends GrenadeEntity> type, World world, LivingEntity thrower, int time, int blastRadius, boolean explodesOnImpact, Item item) {
        super(type, world);
        if (thrower != null) {
            this.func_70107_b(thrower.func_226277_ct_(), thrower.func_226278_cu_() + (double)thrower.func_70047_e(), thrower.func_226281_cx_());
        }
        this.func_212361_a((Entity)thrower);
        this.fuse = time;
        this.blastRadius = blastRadius;
        this.explodesOnImpact = explodesOnImpact;
        this.setInitialMotion(thrower);
        this.item = item;
    }

    private static double sqr(double n) {
        return n * n;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void doExplosion() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), (float)this.blastRadius, Explosion.Mode.NONE);
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        Vector3d to;
        Vector3d from;
        RayTraceContext context;
        BlockRayTraceResult rayTraceResult;
        --this.fuse;
        if (this.fuse < 0) {
            this.doExplosion();
        }
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        Vector3d deltaMovement = this.func_213322_ci();
        double prevMotionX = deltaMovement.field_72450_a;
        double prevMotionY = deltaMovement.field_72448_b;
        double prevMotionZ = deltaMovement.field_72449_c;
        if (!this.field_70170_p.field_72995_K && (rayTraceResult = this.field_70170_p.func_217299_a(context = new RayTraceContext(from = this.func_213303_ch(), to = from.func_72441_c(deltaMovement.field_72450_a, deltaMovement.field_72448_b, deltaMovement.field_72449_c), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this))) != null && rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            this.onCollide(from, to, rayTraceResult, context);
        }
        this.func_213315_a(MoverType.SELF, deltaMovement);
        deltaMovement = this.func_213322_ci();
        boolean bouncedThisTick = false;
        double bounceX = deltaMovement.field_72450_a;
        double bounceY = deltaMovement.field_72448_b;
        double bounceZ = deltaMovement.field_72449_c;
        if (deltaMovement.field_72450_a != prevMotionX) {
            bounceX = -0.25 * prevMotionX;
            bouncedThisTick = true;
        }
        if (deltaMovement.field_72448_b != prevMotionY) {
            bounceY = -0.25 * prevMotionY;
            bouncedThisTick = true;
        }
        if (deltaMovement.field_72449_c != prevMotionZ) {
            bounceZ = -0.25 * prevMotionZ;
            bouncedThisTick = true;
        }
        if (bouncedThisTick) {
            this.onGrenadeBounce(this.func_213322_ci());
        }
        this.func_213293_j(bounceX, bounceY, bounceZ);
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.039, 0.0));
        }
        this.func_213317_d(this.func_213322_ci().func_216369_h(AIR_DRAG_MULTIPLIER));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216369_h(GROUND_DRAG_MULTIPLIER));
        }
        this.lastRotation = this.rotation;
        if (this.field_70170_p.field_72995_K && !this.field_70122_E && !this.func_213322_ci().equals((Object)Vector3d.field_186680_a)) {
            this.rotation += 15.0f;
        }
        this.onThrowableTick();
    }

    public final void onCollide(Vector3d from, Vector3d to, BlockRayTraceResult result, RayTraceContext traceContext) {
        BlockRayTraceResult rayTraceResult;
        BlockPos pos = result.func_216350_a();
        BlockState state = this.field_70170_p.func_180495_p(pos);
        boolean hasBrokenGlass = false;
        if (state.func_185904_a() == Material.field_151592_s) {
            this.field_70170_p.func_175655_b(pos, false);
            hasBrokenGlass = true;
        }
        if (hasBrokenGlass && (rayTraceResult = this.field_70170_p.func_217299_a(traceContext)) != null && rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            this.onCollide(from, to, rayTraceResult, traceContext);
        }
    }

    public boolean func_70112_a(double p_70112_1_) {
        return true;
    }

    public void onThrowableTick() {
    }

    public void bounce() {
        if (this.explodesOnImpact) {
            this.doExplosion();
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        CompoundNBT nbt = new CompoundNBT();
        this.func_213281_b(nbt);
        buffer.func_150786_a(nbt);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        CompoundNBT nbt = additionalData.func_150793_b();
        this.func_70037_a(nbt);
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_74768_a("fuse", this.fuse);
        nbt.func_74768_a("timesBounced", this.timesBounced);
        nbt.func_74768_a("blast", this.blastRadius);
        nbt.func_74757_a("impact", this.explodesOnImpact);
        nbt.func_74778_a("item", this.item.getRegistryName().toString());
    }

    protected void func_70037_a(CompoundNBT nbt) {
        this.fuse = nbt.func_74762_e("fuse");
        this.timesBounced = nbt.func_74762_e("timesBounced");
        this.blastRadius = nbt.func_74762_e("blast");
        this.explodesOnImpact = nbt.func_74767_n("impact");
        String registryName = nbt.func_74779_i("item");
        this.item = registryName == null || registryName.isEmpty() ? Items.field_190931_a : (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
    }

    protected void func_70088_a() {
    }

    private void setInitialMotion(LivingEntity thrower) {
        if (thrower == null) {
            return;
        }
        float modifier = 1.6f;
        if (thrower instanceof PlayerEntity && PlayerData.hasActiveSkill((PlayerEntity)thrower, Skills.GRENADIER)) {
            modifier *= 1.4f;
        }
        Vector3d viewVec = thrower.func_70040_Z();
        Vector3d thrVec = viewVec.func_216372_d(0.75, 0.75, 0.75);
        this.func_213293_j(thrVec.field_72450_a * (double)modifier, thrVec.field_72448_b * (double)modifier / (double)1.2f, thrVec.field_72449_c * (double)modifier);
    }

    private void onGrenadeBounce(Vector3d movement) {
        double z;
        double y;
        double x = GrenadeEntity.sqr(movement.field_72450_a);
        if (Math.sqrt(x * x + (y = GrenadeEntity.sqr(movement.field_72448_b)) * y + (z = GrenadeEntity.sqr(movement.field_72449_c)) * z) >= 0.2) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187677_b, SoundCategory.MASTER, 1.0f, 1.8f);
        }
        ++this.timesBounced;
        this.bounce();
    }
}

